<?php

namespace App\Http\Controllers\ControlPanel;

use App\Http\Controllers\Controller;
use App\Models\OrderProduct;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

class OrderProductsController extends Controller
{
    public function index(Request $request)
    {

        if ($request->ajax()) {
            $orders = OrderProduct::get();
            return datatables()->of($orders)
                ->addColumn('product', function (OrderProduct $order) {
                    if(LaravelLocalization::getCurrentLocale() == 'ar')
                    {
                        return $order->product->name_ar;
                    } else {
                        return $order->product->name_en;
                    }
                })
                ->addColumn('date', function (OrderProduct $order) {
                    return  Carbon::parse($order->created_at)->format('Y-m-d');
                })

                ->addColumn('actions', function (OrderProduct $order) {
                    $delete = '<a href="#" class="btn btn-danger btn-sm" data-toggle= "modal" data-target= "#modals-delete-' . $order->id . '">' .
                        __('حذف').'</a>';
                    $show = ' <a href="' . route('order-products.show', $order->id) . '" class="btn btn-sm btn-success">'.__('عرض').'</a>';

                    return $delete . $show;

                })
                ->rawColumns(['actions'])
                ->make(true);
        }
        # code...
        $orders = OrderProduct::get();

        return view('control-panel.order_products.index',[
            'orders' => $orders
        ]);
    }

    public function show(OrderProduct $order_product)
    {
        # code...


        if($order_product->status == "0"){

            $order_product->update([
                'status' => "1"
            ]);
        }
        return view('control-panel.order_products.edit',[
            'order' => $order_product,
        ]);
    }

    public function destroy(OrderProduct $order_product)
    {
        # code...
        $order_product->delete();
        return redirect()->route('order-products.index')->with('success',__('Message Deleted Successfully!'));
    }
}
