<?php

namespace App\Http\Controllers\ControlPanel;

use App\Http\Controllers\Controller;
use App\Models\Menu;
use Illuminate\Http\Request;
use function redirect;
use function view;

class MenuController extends Controller
{

    public function index(Request $request)
    {
        if ($request->ajax()) {
            $menus = Menu::all();
            return datatables()->of($menus)
                ->addColumn('parent', function (Menu $menu) {
                    return $menu->parent->name ?? 'رئيسي';
                })
                ->addColumn('actions', function (Menu $menu) {
                    $delete = '';
                    if($menu->status == 0){
                    $delete = '<a href="#" class="btn btn-danger btn-sm" data-toggle= "modal" data-target= "#modals-delete-' . $menu->id . '">' .
                        __('حذف').'</a>';
                    }
                    $edit = ' <a href="' . route('menus.edit', $menu->id) . '" class="btn btn-sm btn-primary">'.__('تعديل').'</a>';

                    return $delete . $edit;

                })
                ->rawColumns(['actions', 'image'])
                ->addIndexColumn()
                ->make(true);
        }

        $menus = Menu::all();
        return view('control-panel.menus.index', compact('menus'));
    }


    public function create()
    {
        $menus = Menu::where('parent_id', 0)->get();

        return view('control-panel.menus.create', [
            'menus' => $menus
        ]);
    }


    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string',
            'name_ar' => 'required|string',
            'link' => 'required|string',
            'slug' => 'required|string|unique:menus,slug',
            'parent_id' => 'nullable',
        ]);
        Menu::create($request->all());

        return redirect()->route('menus.index')->with('success', 'Menu Created Successfully!');
    }


    public function edit(Menu $menu)
    {
        $menus = Menu::where('parent_id', 0)->get();
        return view('control-panel.menus.edit', [
            'menu' => $menu,
            'menus' => $menus,
        ]);
    }

    public function update(Request $request, Menu $menu)
    {
        // dd($request->all());
        $request->validate([
            'name' => 'required|string',
            'name_ar' => 'required|string',
            'link' => 'string',
            'slug' => "string|unique:menus,slug, $menu->id",
        ]);

        $menu->update($request->all());
        return redirect()->route('menus.index')->with('success', 'Menu Updated Successfully!');
    }

    public function destroy(Menu $menu)
    {
        $menu->delete();
        return redirect()->back()->with('success', 'Menu Deleted Successfully');
    }
}
