<?php

namespace App\Http\Controllers\ControlPanel;

use App\Http\Controllers\Controller;
use App\Models\FAQ;
use Illuminate\Http\Request;

class FAQController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $faqs = FAQ::get();
            return datatables()->of($faqs)
                ->addIndexColumn()
                ->addColumn('actions', function (FAQ $faq) {
                    $delete = '';
                    $delete = '<a href="#" class="btn btn-danger btn-sm" data-toggle= "modal" data-target= "#modals-delete-faqs' . $faq->id . '">
                            ' . __('حذف') . '</a>';
                    $edit = '<a href="#" class="btn btn-primary btn-sm" style="margin-right:10px;" data-toggle= "modal" data-target= "#modals-update-faqs' . $faq->id . '">
                            ' . __('تعديل') . '</a>';

                    return $delete . $edit;

                })
                ->rawColumns(['actions'])
                ->make(true);
        }

        $faqs = FAQ::get();

        return view('control-panel.FAQs.index', [
            'faqs' => $faqs
        ]);
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'question' => 'required|string',
            'description' => 'required|string',
        ]);

        // dd($request);

        FAQ::create($request->all());


        return redirect()->route('faqs.index')->with('success', __(' Created Done!'));
    }


    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $faq = FAQ::findOrFail($id);

        $request->validate([
            'question' => 'required|string',
            'description' => 'required|string',
        ]);


        $faq->update($request->all());

        return redirect()->route('faqs.index')->with('success', __(' Updated Done!'));


    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $faq = FAQ::findOrFail($id);

        $faq->delete();


        return redirect()->route('faqs.index')->with('success', __('Deleted Done!'));

    }
}
