<?php

namespace App\Http\Controllers\ControlPanel;

use App\Http\Controllers\Controller;
use App\Models\Client;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

class ClientsContoller extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {

            $draw = $request->get('draw');
            $start = $request->get("start");
            $rowperpage = $request->get("length"); // Rows display per page
            $search_arr = $request->get('search');
            $searchValue = $search_arr['value']; // Search value
            $totalRecords = Client::select('count(*) as allcount')->count();
            $totalRecordswithFilter = Client::select('count(*) as allcount')
                                                ->where('name', 'like', '%' . $searchValue . '%')
                                                ->orWhere('name_ar', 'like', '%' . $searchValue . '%')
                                                ->count();

            $clients = Client::select('clients.*')
                ->where('name', 'like', '%' . $searchValue . '%')
                ->orWhere('name_ar', 'like', '%' . $searchValue . '%')
                ->skip($start)
                ->take($rowperpage)
                ->orderBy('clients.id', 'desc')
                ->get();


            $records = [];

            foreach($clients as $item)
            {
                $name = '';
                if(LaravelLocalization::getCurrentLocale() == 'ar') {
                    $name = $item->name_ar;
                }else{
                    $name = $item->name;
                }
                $records[] = [
                       'image' => '<img src="'. asset('storage/'.$item->image) .'" width="80">',
                       'name' => $name,
                       'actions' => view('control-panel.clients.datatable.buttons',[ 'item' => $item ])->render() ,
                    ];
            }

            $response = [
                        "draw" => intval($draw),
                        "iTotalRecords" => $totalRecords,
                        "iTotalDisplayRecords" => $totalRecordswithFilter,
                        "aaData" => $records
                    ];

            return response()->json($response);

        }

        return view('control-panel.clients.index');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'name_ar' => 'required|string|max:255',
            'image' => 'required|mimes:png,jpg',
        ]);

        $image = null;
        if($request->hasFile('image') && $request->file('image')->isValid()){
            $image = $request->file('image')->store('partners','public');
        }

        Client::create([
            'name' => $request->name,
            'name_ar' => $request->name_ar,
            'image' => $image,
        ]);

        return redirect()->route('clients.index')->with('success', __('تم اضافة بنجاح') );

    }

    public function update(Request $request, Client $client)
    {
        # code...
        $request->validate([
            'name' => 'required|string|max:255',
            'name_ar' => 'required|string|max:255',
            'image' => 'nullable|mimes:png,jpg',
        ]);

        $image = $client->image;
        if($request->hasFile('image') && $request->file('image')->isValid()){
            Storage::disk('public')->delete($image);
            $image = $request->file('image')->store('clients','public');
        }

        $client->update([
            'name' => $request->name,
            'name_ar' => $request->name_ar,
            'image' => $image,
        ]);

        return redirect()->route('clients.index')->with('success',__('تم التعديل بنجاح'));
    }

     /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy( Client $client)
    {

        $client->delete();
        Storage::disk('public')->delete($client->image);
        return redirect()->route('clients.index')->with('success',__('تم حذف الشريك بنجاح'));
    }

}
