<?php

namespace App\Http\Controllers\ControlPanel;

use App\Http\Controllers\Controller;
use App\Models\ClientOpinion;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class ClientOpinionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {

            $clients = ClientOpinion::all();
            return datatables()->of($clients)
                ->editColumn('image', function (ClientOpinion $client) {
                    if($client->image){
                        return '<img src="' . asset('storage/' . $client->image) . '" width="50" alt="' . $client->name . '">';
                    }else{
                        return '<img src="' . asset('storage/Group 45.png') . '" width="50" alt="' . $client->name . '">';
                    }
                })
                ->addColumn('actions', function (ClientOpinion $client) {
                    $delete = '';
                    $delete = '<a href="#" class="btn btn-danger btn-sm" data-toggle= "modal" data-target= "#modals-delete-' . $client->id . '">' .
                        __('حذف').'</a>';
                    $edit = ' <a href="' . route('client-opinion.edit', $client->id) . '" class="btn btn-sm btn-primary">'.__('تعديل').'</a>';

                    return $delete . $edit;

                })
                ->rawColumns(['actions', 'image'])
                ->make(true);
        }
        $clients = ClientOpinion::all();

        return view('control-panel.client-opinions.index', [
            'clientOpinions' => $clients,
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('control-panel.client-opinions.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string',
            'name_ar' => 'required|string',
            'image' => 'nullable|mimes:jpg,png',
            'message' => 'required|string',
            'message_ar' => 'required|string',
            'client_position' => 'required|string',
            'client_position_ar' => 'required|string'
        ]);

        $data = $request->all();

        $image = null;
        if ($request->hasFile('image') && $request->file('image')->isValid()) {
            $image = $request->file('image')->store('client-opinion', 'public');
        }

        $data['image'] = $image;

        ClientOpinion::create($data);

        return redirect()->route('client-opinion.index')->with('success','تم انشاء الرأي بنجاح');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(ClientOpinion $client_opinion)
    {
        // dd($client_opinion);
        return view('control-panel.client-opinions.edit',[
            'client' => $client_opinion,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,ClientOpinion $client_opinion)
    {
        $request->validate([
            'name' => 'required|string',
            'name_ar' => 'required|string',
            'image' => 'nullable|mimes:jpg,png',
            'message' => 'required|string',
            'message_ar' => 'required|string',
            'client_position' => 'required|string',
            'client_position_ar' => 'required|string'
        ]);

        $data = $request->all();

        $image = $client_opinion->image;
        if ($request->hasFile('image') && $request->file('image')->isValid()) {
            Storage::disk('public')->delete($image);
            $image = $request->file('image')->store('client-opinion', 'public');
        }

        $data['image'] = $image;

        $client_opinion->update($data);

        return redirect()->route('client-opinion.index')->with('success','تم التعديل على الرأي بنجاح');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(ClientOpinion $client_opinion)
    {
        Storage::disk('public')->delete($client_opinion->image);
        $client_opinion->delete();
        return redirect()->route('client-opinion.index')->with('success','تم حذف الرأي بنجاح');
    }
}
