<?php

namespace App\Http\Controllers\ControlPanel;

use App\Http\Controllers\Controller;
use App\Models\CategoryText;
use App\Models\ServiceText;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class CategoryTextController extends Controller
{
 /**
     * this function for view website edit page
     *
     * @return \Illuminate\View\View
     */
    public function edit()
    {
        $category_text = CategoryText::latest()->first();


        return view('control-panel.category_text.edit',[
            'category_text' => $category_text,
        ]);
    }


    /**
     * this function for update website setting in database or create new setting
     *
     * @param Illuminate\Http\Request $request
     *
     * @return \Illuminate\View\View
     */
    public function update(Request $request){

        $category_text = CategoryText::latest()->first();

        if(!$category_text){
            $request->validate([
                'title' => 'required |string',
                'sub_title' => 'string|nullable',
                'image' => 'required |mimes:png,jpg',
            ]);
            $data = $request->all();

            $image = null;

            if ($request->hasFile('image') && $request->file('image')->isValid()) {
                $image = $request->file('image')->store('categories', 'public');
            }

            $data['image'] = $image;

            $category = CategoryText::create($data);
        }else{
            $request->validate([
                'title' => 'required |string',
                'sub_title' => 'string|nullable',
                'image' => 'nullable |mimes:png,jpg',
            ]);
            $data = $request->all();

            $image = $category_text->image;

            if ($request->hasFile('image') && $request->file('image')->isValid()) {
                Storage::disk('public')->delete($image);
                $image = $request->file('image')->store('categories', 'public');
            }

            $data['image'] = $image;

            $category = $category_text;
            $category->update($data);
        }

        return redirect()->route('category-text-edit')->with('success',__('Update Done!'));

    }
}
