<?php

namespace App\Http\Controllers\ControlPanel;

use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Models\Menu;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class CategoriesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // dd(55);
        if ($request->ajax()) {
            $categories = Category::all();
            return datatables()->of($categories)
                ->addIndexColumn()
                ->addColumn('actions', function (Category $category) {

                    $delete = '<a href="javascript:void(0);" class="btn btn-danger btn-sm" data-toggle= "modal" data-target= "#modals-delete-' . $category->id . '">'
                        .  __('حذف') . '</a>';
                    $edit = ' <a href="javascript:void(0);" class="btn btn-sm btn-primary" data-toggle= "modal" data-target= "#modals-edit-' . $category->id . '">' . __('تعديل') . '</a>';

                    return $delete . $edit;

                })
                ->rawColumns(['actions'])
                ->make(true);
        }

        $categories = Category::all();
        return view('control-panel.categories.index', [
            'categories' => $categories
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name_ar' => ['required', 'string', 'max:255'],
            'name_en' => ['required', 'string', 'max:255'],
            'image' => 'required|mimes:png,jpg'
        ]);

        $data = $request->all();
        $image = null;

        if ($request->hasFile('image') && $request->file('image')->isValid()) {
            $image = $request->file('image')->store('categories', 'public');
        }

        $data['image'] = $image;

        $category = Category::create($data);

        return redirect()->route('categories.index')->with('success', __('المصنف ') . $category->name_ar . __(' Created Done!'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
       // dd($request);
        $request->validate([
            'name_ar' => ['required', 'string', 'max:255'],
            'name_en' => ['required', 'string', 'max:255'],
            'image' => 'nullable|mimes:png,jpg'
        ]);
        $category = Category::findOrFail($id);

        $data = $request->all();
        $image = $category->image;

        if ($request->hasFile('image') && $request->file('image')->isValid()) {
            Storage::disk('public')->delete($image);
            $image = $request->file('image')->store('categories', 'public');
        }

        $data['image'] = $image;
        //dd($data);

        $category->update($data);

        return redirect()->route('categories.index')->with('success', __('المصنف ') . $category->name_ar . __(' Updated Done!'));

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

        $category = Category::findOrFail($id);
        Storage::disk('public')->delete($category->image);
        $category->delete();
        return redirect()->route('categories.index')->with('success', __('Category Deleted Done!'));
    }
}
