<?php

namespace App\Http\Controllers\ControlPanel;

use App\Http\Controllers\Controller;
use App\Models\Benefit;
use App\Models\Product;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

class BenefitsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        $x = $request->query('productID');
        if ($request->ajax()) {

            if($request->product_id){
            $product = Product::findOrFail($request->product_id);
            $benefits = $product->benefit;
            }else{
                $benefits = [];
            }

            return datatables()->of($benefits)
                ->addIndexColumn()
                ->addColumn('title', function (Benefit $benefit) {
                    if (LaravelLocalization::getCurrentLocale() == 'ar') {
                        return $benefit->title_ar;
                    } else {
                        return $benefit->title_en;
                    }
                })
                ->addColumn('sub_title', function (Benefit $benefit) {
                    if (LaravelLocalization::getCurrentLocale() == 'ar') {
                        return $benefit->sub_title_ar;
                    } else {
                        return $benefit->sub_title_en;
                    }
                })
                ->addColumn('product', function (Benefit $benefit) {
                    if (LaravelLocalization::getCurrentLocale() == 'ar') {
                        return $benefit->product->name_ar;
                    } else {
                        return $benefit->product->name_en;
                    }
                })
                ->addColumn('actions', function (Benefit $benefit) {
                    $delete = '<a href="javascript:void(0);" class="btn btn-danger btn-sm" data-toggle= "modal" data-target= "#modals-delete-' . $benefit->id . '">'
                        . __('حذف') . '</a>';
                    $edit = ' <a href="javascript:void(0);" class="btn btn-sm btn-primary" data-toggle= "modal" data-target= "#modals-edit-' . $benefit->id . '">' . __('تعديل') . '</a>';
                    $addbenefit = ' <a href="' . route('sub-benefit.index', $benefit->id) . '" class="btn btn-sm btn-success">' . __('اضافة ميزة فرعية') . '</a>';


                    return $delete . $edit .  $addbenefit;
                })
                ->rawColumns(['actions'])
                ->make(true);
        }

        $benefits = Benefit::all();
        return view('control-panel.benefits.index', [
            'benefits' => $benefits
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'image' => 'required|mimes:png,jpg',
            'title_ar' => 'required|string',
            'title_en' => 'required|string',
            'sub_title_ar' => 'nullable|string',
            'sub_title_en' => 'nullable|string',
            'description_ar' => 'required|string',
            'description_en' => 'required|string',
            'product_id' => 'required|exists:products,id',
            'status' => 'required|in:0,1'
        ]);

        $data = $request->all();
        $image = null;

        if ($request->hasFile('image') && $request->file('image')->isValid()) {
            $image = $request->file('image')->store('benefits', 'public');
            $data['image'] = $image;
        }

        Benefit::create($data);

        return redirect(route('benefits.index') . '?productID=' . $request->product_id)->with('success', __(' Created Done!'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Benefit $benefit)
    {
        $request->validate([
            'image' => 'nullable|mimes:png,jpg',
            'title_ar' => 'required|string',
            'title_en' => 'required|string',
            'sub_title_ar' => 'nullable|string',
            'sub_title_en' => 'nullable|string',
            'description_ar' => 'required|string',
            'description_en' => 'required|string',
            'product_id' => 'required|exists:products,id',
            'status' => 'required|in:0,1'
        ]);


        $data = $request->all();
        $image = $benefit->image;

        if ($request->hasFile('image') && $request->file('image')->isValid()) {
            Storage::disk('public')->delete($image);
            $image = $request->file('image')->store('benefits', 'public');
            $data['image'] = $image;
        }

        $benefit->update($data);

        return redirect(route('benefits.index') . '?productID=' . $request->product_id)->with('success', __('Update Done!'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Benefit $benefit)
    {
        $product_id = $benefit->product_id;
        $benefit->delete();

        return redirect(route('benefits.index') . '?productID=' . $product_id)->with('success', __('Deleted Done!'));
    }


    public function viewSubBenefit($id)
    {
        # code...

        $benefit = Benefit::findOrFail($id);
        return view('control-panel.benefits.sub-benefit.index', [
            'benefit' => $benefit,
        ]);
    }

    public function storeSubBenefit($id, Request $request)
    {

        $sub_benefit = $request->invoice;

        $benefit = Benefit::findOrFail($id);
        $benefit->subBenefits()->delete();

        for ($i = 0; $i < count($sub_benefit); $i++) {
            $benefit->subBenefits()->create([
                'title_ar' => $sub_benefit[$i]['title_ar'],
                'title_en' => $sub_benefit[$i]['title_en'],
                'description_ar' => $sub_benefit[$i]['description_ar'],
                'description_en' => $sub_benefit[$i]['description_en'],
            ]);
        }

        return redirect()->route('benefits.index')->with('success',__('Update Done!'));
    }
}
