<?php

namespace App\Http\Controllers\ControlPanel;

use App\Http\Controllers\Controller;
use App\Models\AboutUs;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class AboutUsController extends Controller
{
     /**
     * this function for view website edit page
     *
     * @return \Illuminate\View\View
     */
    public function edit()
    {
        $about_us = AboutUs::latest()->first();


        return view('control-panel.about_us.edit',[
            'about_us' => $about_us,
        ]);
    }


    /**
     * this function for update website setting in database or create new setting
     *
     * @param Illuminate\Http\Request $request
     *
     * @return \Illuminate\View\View
     */
    public function update(Request $request){

        $about_us = AboutUs::latest()->first();

        if(!$about_us){
            $request->validate([
                'slider_title' => 'required |string',
                'slider_sub_title' => 'string|required',
                'slider_image' => 'image |required |mimes:jpg,png',
                'slider_description' => 'required |string',
                'title' => 'required |string',
                'sub_title' => 'string|required',
                'description' => 'required |string',
                'image' => 'image |required |mimes:jpg,png',
                'slider_title_ar' => 'required |string',
                'slider_sub_title_ar' => 'string|required',
                'slider_description_ar' => 'required |string',
                'title_ar' => 'required |string',
                'sub_title_ar' => 'string|required',
                'description_ar' => 'required |string',
                'vision' => 'required |string',
                'vision_ar' => 'required |string',
                'mission' => 'required |string',
                'mission_ar' => 'required |string',
            ]);
            $data = $request->all();

            $slider_image = null;

            if($request->hasFile('slider_image') && $request->file('slider_image')->isValid()){
                $slider_image = $request->file('slider_image')->store('about_us','public');
            }

            $data['slider_image'] = $slider_image;

            $image = null;

            if($request->hasFile('image') && $request->file('image')->isValid()){
                $image = $request->file('image')->store('about_us','public');
            }

            $data['image'] = $image;


            $aboutUs = AboutUs::create($data);
            // $this->insertTags($data['features'], $therapeutic_dentistrie);
        }else{
            $request->validate([
                'slider_title' => 'required |string',
                'slider_sub_title' => 'string|required',
                'slider_image' => 'image |nullable |mimes:jpg,png',
                'slider_description' => 'required |string',
                'title' => 'required |string',
                'sub_title' => 'string|required',
                'description' => 'required |string',
                'image' => 'image |nullable |mimes:jpg,png',
                'slider_title_ar' => 'required |string',
                'slider_sub_title_ar' => 'string|required',
                'slider_description_ar' => 'required |string',
                'title_ar' => 'required |string',
                'sub_title_ar' => 'string|required',
                'description_ar' => 'required |string',
                'vision' => 'required |string',
                'vision_ar' => 'required |string',
                'mission' => 'required |string',
                'mission_ar' => 'required |string',
            ]);
            $data = $request->all();

            $slider_image = $about_us->slider_image;

            if($request->hasFile('slider_image') && $request->file('slider_image')->isValid()){
                Storage::disk('public')->delete($slider_image);
                $slider_image = $request->file('slider_image')->store('about_us','public');
            }

            $data['slider_image'] = $slider_image;

            $image = $about_us->image;

            if($request->hasFile('image') && $request->file('image')->isValid()){
                Storage::disk('public')->delete($image);
                $image = $request->file('image')->store('about_us','public');
            }

            $data['image'] = $image;


            $aboutUs = $about_us;

            $aboutUs->update($data);
        }

        return redirect()->route('about-us-edit',[
            'about_us' => $aboutUs
        ])->with('success',__('Update Done!'));

    }
}
